%% Molecular Dynamics Simulator
% <md.m> Mark D. Shattuck 7/22/2010

% revision history:
% 7/22/2010 Mark D. Shattuck <mds> md.m
%           MD Demo for HandsOn 2010
%           000 mds Initial conditions and visualization
% 7/24/2010 001 mds Add Euler
% 7/24/2010 002 mds Add Interaction detection and Force Law

%% Experimental Parmeters
N=10;  % number of particles
D=2;   % diameter of particles
K=100; % spring constant for harmonic force law
M=3;   % mass of particles

Lx=10*D;  % size of box
Ly=10*D;

%% Simulation Parmeters
dt=1e-2;

%% Initial Conditions
[x y]=ndgrid(D/2:D:Lx-D/2,D/2:D:Ly-D/2);  
ii=randperm(numel(x),N);
x=x(ii(1:N));
y=y(ii(1:N));

vx=randn(1,N)/3;
vy=randn(1,N)/3;

%% Setup Plotting
clf;
h=zeros(1,N);
for np=1:N
  h(np)=rectangle('Position',[x(np)-.5*D y(np)-.5*D D D],'Curvature',[1 1],'edgecolor','b');
end
axis('equal');
axis([0 Lx 0 Ly]);

%% Main Loop

for nt=1:10000
  for np=1:N
    set(h(np),'Position',[x(np)-.5*D y(np)-.5*D D D]);
  end
  drawnow;
  
  % Interaction detector and Force Law
  Fx=zeros(1,N);
  Fy=zeros(1,N);
  
  for nn=1:N-1         % particle 1
    for mm=nn+1:N    % particle 2
      dy=y(mm)-y(nn);
      if(abs(dy)<=D)
        dx=x(mm)-x(nn);
        dnm=dx.^2+dy.^2; % dnm=dnm^2
        if(dnm<D^2)
          dnm=sqrt(dnm);
          F=-K*(D/dnm-1);
          Fx(nn)=Fx(nn)+F.*dx;  % particle-particle Force Law
          Fx(mm)=Fx(mm)-F.*dx;
          Fy(nn)=Fy(nn)+F.*dy;  % particle-particle Force Law
          Fy(mm)=Fy(mm)-F.*dy;
        end
      end
    end
  end
  
  ii=x<D/2;
  dw=x(ii)-D/2; % Left wall
  Fx(ii)=Fx(ii)-K*dw;  
  
  ii=y<D/2;
  dw=y(ii)-D/2;  % Bottom wall
  Fy(ii)=Fy(ii)-K*dw;  
  
  ii=x>Lx-D/2;
  dw=x(ii)-(Lx-D/2);  % Right wall
  Fx(ii)=Fx(ii)-K*dw;  
  
  ii=y>Ly-D/2;
  dw=y(ii)-(Ly-D/2);  % Top wall
  Fy(ii)=Fy(ii)-K*dw;  
  
  ax=Fx/M;
  ay=Fy/M;
  
  x=x+vx*dt;
  y=y+vy*dt;

  vx=vx+ax*dt;
  vy=vy+ay*dt;

end

