%% Molecular Dynamics Simulator
% <md.m> Mark D. Shattuck 7/22/2010

% revision history:
% 7/22/2010 Mark D. Shattuck <mds> md.m
%           MD Demo for HandsOn 2010
%           000 mds Initial conditions and visualization
% 7/24/2010 001 mds Add Euler

%% Experimental Parmeters
N=10;  % number of particles
D=2;   % diameter of particles
M=3;   % mass of particles

Lx=10*D;  % size of box
Ly=10*D;

%% Simulation Parmeters
dt=1e-2;

%% Initial Conditions
[x y]=ndgrid(D/2:D:Lx-D/2,D/2:D:Ly-D/2);  
ii=randperm(numel(x),N);
x=x(ii);
y=y(ii);

vx=randn(1,N)/10;
vy=randn(1,N)/10;

%% Setup Plotting
clf;
h=zeros(1,N);
for np=1:N
  h(np)=rectangle('Position',[x(np)-.5*D y(np)-.5*D D D],'Curvature',[1 1],'edgecolor','b');
end
axis('equal');
axis([0 Lx 0 Ly]);

%% Main Loop

for nt=1:10000
  for np=1:N
    set(h(np),'Position',[x(np)-.5*D y(np)-.5*D D D]);
  end
  drawnow;
  
  %Force Law
  Fx=0;
  Fy=-.1;
  
  ax=Fx/M;
  ay=Fy/M;
  
  % integrator
  x=x+vx*dt;
  y=y+vy*dt;

  vx=vx+ax*dt;
  vy=vy+ay*dt;
    
  % Boundary Conditions
  x=mod(x,Lx);
  y=mod(y,Ly);
end

