%% Molecular Dynamics Simulator
% <md.m> Mark D. Shattuck 7/22/2010

% revision history:
% 7/22/2010 Mark D. Shattuck <mds> md.m
%           MD Demo for HandsOn 2010
%           000 mds Initial conditions and visualization

%% Parmeters
N=20;  % number of particles
D=2;   % diameter of particles
M=3;   % mass of particles

Lx=10*D;  % size of box
Ly=10*D;

%% Initial Conditions





%% Setup Plotting
clf;
h=zeros(1,N);
for np=1:N
  h(np)=rectangle('Position',[x(np)-.5*D y(np)-.5*D D D],'Curvature',[1 1],'edgecolor','b');
end
axis('equal');
axis([0 Lx 0 Ly]);

%% Main Loop

for nt=1:1000
  % plots particles
  for np=1:N
    set(h(np),'Position',[x(np)-.5*D y(np)-.5*D D D]);
  end
  drawnow;
  
  % Add code between these comments to make particles move
    
  
  % Add code between these comments to make particles move
end

%% end










%% Initial Conditions
[x,y]=ndgrid(D/2:D:Lx-D/2,D/2:D:Ly-D/2);
ii=randperm(numel(x),N);
x=x(ii);
y=y(ii);
